package djrestrict_target

import (
	"djextrafunc"
	"djgetad"
	"djlogger"
	openrtb3 "openrtb/openrtb3"
	"reflect"
	"strings"

	openrtb "openrtb/openrtb2.5"
)

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	restrictobj   *openrtb3.Restrictions
	restrictobj25 openrtb.Restrictions
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "-", "", count), "-")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall restrict targeting criteria
func CheckRestrictCriteria(restrictChannel chan []djgetad.GetAd, r int, restrict *openrtb3.Restrictions, restrict25 openrtb.Restrictions, ads []djgetad.GetAd) {
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			restrictChannel <- filterads
		}
	}()
	if r == 1 {
		restrictobj = restrict
	} else if r == 2 {
		restrictobj25 = restrict25
	}
									validate_campaign := make(map[int]int)

	for _, ad := range ads {
		
		if validate_campaign[ad.Placement_id] == 1 {
			
			filterads = append(filterads, ad)
			continue
		}
		
		if validate_campaign[ad.Placement_id] == 2 {
			continue
		} 
		
		validate_campaign[ad.Placement_id] = 2 // by default not match 
		
		
		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads, ad)
				validate_campaign[ad.Placement_id] = 1 // match
			}
		} else {
			filterads = append(filterads, ad)
			validate_campaign[ad.Placement_id] = 1 // match
		}
	}
	restrictChannel <- filterads
}

/* -----------------------------------------------------------------------------------
					Restriction Targetting Start(11-04-20)
--------------------------------------------------------------------------------------*/
// Blocked category start
func (c Commander) MAX_checkClient_BlockedCategory(cmd Command) bool {
	var reqBlockedCategory []string
	var argBlockedCategory []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	if len(restrictobj.Bcat) > 0 {
		for _, cat := range restrictobj.Bcat {
			reqBlockedCategory = append(reqBlockedCategory, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	} else if len(restrictobj25.Bcat) > 0 {
		for _, cat := range restrictobj25.Bcat {
			reqBlockedCategory = append(reqBlockedCategory, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argBlockedCategory = append(argBlockedCategory, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqBlockedCategory != nil {
		if op == "==" {
			return !djextrafunc.CheckEqual(reqBlockedCategory, argBlockedCategory)
		} else if op == "!=" {
			return djextrafunc.CheckEqual(reqBlockedCategory, argBlockedCategory)
		} else if op == "=~" {
			for _, v := range argBlockedCategory {
				for _, v1 := range reqBlockedCategory {
					if v1 == v {
						return false
					}
				}
			}
			return true
		} else if op == "!~" {
			for _, v := range argBlockedCategory {
				for _, v1 := range reqBlockedCategory {
					if v1 == v {
						return true
					}
				}
			}
			return false
		}
	}
	return true
}

// Blocked category end

// Blocked advertisers start
func (c Commander) MAX_checkClient_BlockedAdvertiser(cmd Command) bool {
	var reqBlockedAdvertiser []string
	var argBlockedAdvertiser []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	if len(restrictobj.Badv) > 0 {
		for _, cat := range restrictobj.Badv {
			reqBlockedAdvertiser = append(reqBlockedAdvertiser, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	} else if len(restrictobj25.Badv) > 0 {
		for _, cat := range restrictobj25.Badv {
			reqBlockedAdvertiser = append(reqBlockedAdvertiser, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argBlockedAdvertiser = append(argBlockedAdvertiser, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqBlockedAdvertiser != nil {
		if op == "==" {
			return !djextrafunc.CheckEqual(reqBlockedAdvertiser, argBlockedAdvertiser)
		} else if op == "!=" {
			return djextrafunc.CheckEqual(reqBlockedAdvertiser, argBlockedAdvertiser)
		} else if op == "=~" {
			for _, v := range argBlockedAdvertiser {
				for _, v1 := range reqBlockedAdvertiser {
					if v1 == v {
						return false
					}
				}
			}
			return true
		} else if op == "!~" {
			for _, v := range argBlockedAdvertiser {
				for _, v1 := range reqBlockedAdvertiser {
					if v1 == v {
						return true
					}
				}
			}
			return false
		}
	}
	return true
}

// Blocked advertisers end

// Blocked apps start
func (c Commander) MAX_checkClient_BlockedApps(cmd Command) bool {
	var reqBlockedApps []string
	var argBlockedApps []string
	i := len(cmd.Args) - 1
	op := strings.TrimSpace(strings.Replace(cmd.Args[i], "'", "", -1))
	if len(restrictobj.Bapp) > 0 {
		for _, cat := range restrictobj.Bapp {
			reqBlockedApps = append(reqBlockedApps, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	} else if len(restrictobj25.Bapp) > 0 {
		for _, cat := range restrictobj25.Bapp {
			reqBlockedApps = append(reqBlockedApps, strings.TrimSpace(strings.Replace(strings.ToLower(cat), "'", "", -1)))
		}
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argBlockedApps = append(argBlockedApps, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqBlockedApps != nil {
		if op == "==" {
			return !djextrafunc.CheckEqual(reqBlockedApps, argBlockedApps)
		} else if op == "!=" {
			return djextrafunc.CheckEqual(reqBlockedApps, argBlockedApps)
		} else if op == "=~" {
			for _, v := range argBlockedApps {
				for _, v1 := range reqBlockedApps {
					if v1 == v {
						return false
					}
				}
			}
		} else if op == "!~" {
			for _, v := range argBlockedApps {
				for _, v1 := range reqBlockedApps {
					if v1 == v {
						return true
					}
				}
			}
			return false
		}
	}
	return true
}

// Blocked apps end
/* -----------------------------------------------------------------------------------
					Restriction Targetting End(11-04-20)
--------------------------------------------------------------------------------------*/
